﻿//---------------------------------------------------------------------------------
// Microsoft (R) .NET Services SDK
// Software Development Kit
// 
// Copyright (c) Microsoft Corporation. All rights reserved.  
//
// THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE. 
//---------------------------------------------------------------------------------

namespace Microsoft.AccessControl.SDK.ACSCalculator.AuthorizationManager
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Net;
    using System.ServiceModel;
    using System.ServiceModel.Web;

    public class ACSAuthorizationManager : ServiceAuthorizationManager
    {
        TokenValidator validator;
        string requiredClaimType;

        public ACSAuthorizationManager(string acsHostName, string trustedSolution, string trustedAudienceValue, byte[] trustedSigningKey, string requiredClaimType)
        {
            this.validator = new TokenValidator(acsHostName, trustedSolution, trustedAudienceValue, trustedSigningKey);
            this.requiredClaimType = requiredClaimType;
        }

        protected override bool CheckAccessCore(OperationContext operationContext)
        {
            // get the authorization header
            string authorizationHeader = WebOperationContext.Current.IncomingRequest.Headers[HttpRequestHeader.Authorization];

            if (string.IsNullOrEmpty(authorizationHeader))
            {
                WebOperationContext.Current.OutgoingResponse.StatusCode = HttpStatusCode.Unauthorized;
                return false;
            }

            // validate the token
            if (!this.validator.Validate(authorizationHeader))
            {
                WebOperationContext.Current.OutgoingResponse.StatusCode = HttpStatusCode.Unauthorized;
                return false;
            }

            // check for an action claim and get the value
            Dictionary<string, string> claims = this.validator.GetNameValues(authorizationHeader);

            // use the operation name to determine the requried action value
            string requiredActionClaimValue = WebOperationContext.Current.IncomingRequest.UriTemplateMatch.RelativePathSegments.First();

            string actionClaimValue;
            if (!claims.TryGetValue(this.requiredClaimType, out actionClaimValue))
            {
                WebOperationContext.Current.OutgoingResponse.StatusCode = HttpStatusCode.Unauthorized;
                return false;
            }

            // check for "," delimited values
            string[] actionClaimValues = actionClaimValue.Split(',');

            // check for the correct action claim value
            if (!actionClaimValues.Contains(requiredActionClaimValue))
            {
                WebOperationContext.Current.OutgoingResponse.StatusCode = HttpStatusCode.Unauthorized;
                return false;
            }

            return true;
        }
    }
}
